<?PHP
/*Skrypt pochodzi z ksiki "PHP. 101 praktycznych skryptw"
  autor: Marcin Lis        e-mail: 101scripts@marcinlis.com*/

$img_type = null;

function getImage($imgName)
{
  $ext = substr($imgName, strlen($imgName) - 3, 3);
  $ext = strtolower($ext);
  if($ext == 'jpg'){
         $img = imagecreatefromjpeg($imgName);
         $GLOBALS['img_type'] = IMG_JPEG;
  }
  else if($ext == 'gif'){
         $img = imagecreatefromgif($imgName);
         $GLOBALS['img_type'] = IMG_GIF;
  }
  else if($ext == 'png'){
         $img = imagecreatefrompng($imgName);
         $GLOBALS['img_type'] = IMG_PNG;
  }
  else{
         $img = null;
         $GLOBALS['img_type'] = null;
  }
  return $img;
}

function saveImage($img, $name, $imgType)
{
  $name = substr($name, 0, strlen($name) - 5);
  $name = $name."-resized.";
  switch($imgType){
         case IMG_JPEG:
                $name .= "jpg";
                imagejpeg($img, $name);
                break;
         case IMG_GIF:
                $name .= "gif";
                imagegif($img, $name);
                break;
         case IMG_PNG:
                $name .= "png";
                imagepng($img, $name);
                break;
  }
}

function resize($imgName, $size)
{
  if(!($img = getImage($imgName))){
         echo("Nie mog otworzy pliku: $imgName");
         return false;
  }

  $img_w = imagesx($img);
  $img_h = imagesy($img);

  $ratio = $img_w / $img_h;

  if($ratio > 1){
         $new_img_w = $size;
         $new_img_h = ($size / $ratio);
  }
  else{
         $new_img_w = ($size * $ratio);
         $new_img_h = $size;
  }

  $tempImg = imagecreatetruecolor($new_img_w, $new_img_h);
  imagecopyresized($tempImg, $img, 0, 0, 0, 0, 
         $new_img_w, $new_img_h, $img_w, $img_h);

  saveImage($tempImg, $imgName, $GLOBALS['img_type']);
}
resize("image1.jpg", 200);
?>
